/* <nagg13.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g13 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2162 (Feb 1998).
 * Mark 6 revised. IER-3049 (July 2000).
 */
#ifndef NAGG13
#define NAGG13

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* Message codes and extern of message list */
//#include <nag_g13mesg.h>  //Cheney 2006-6-5
#include "nag_g13mesg.h"
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL g13aac(const double x[], Integer nx, Integer d, Integer ds, Integer s,
					     double xd[], Integer *nxd, NagError *fail);

  extern void g13aac_0(const double x[], Integer nx, Integer nd, Integer nds, Integer ns,
		       double xd[], Integer *nxd, NagError *fail);
  extern void g13aaf_f(const double x[], Integer nx, Integer nd, Integer nds,
                       Integer ns, double xd[], Integer *nxd, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13abc(const double x[], Integer nx, Integer nk, double *mean, double *var,
                                             double r[], double *stat, NagError *fail);
  extern void g13abf_f(const double x[], Integer nx, Integer nk, double *xm,
                       double *xv, double r[], double *stat, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13acc(double r[], Integer nk, Integer nl, double p[], double v[],
                                             double ar[], Integer *nvl, NagError *fail);
  extern void g13adf_f(const Integer mr[], const double r[], Integer nk, double xv,
                       Integer npar, double wa[], Integer nwa, double par[],
                       double *rv, Integer isf[], Integer *ifail);
  extern void g13adx_f(const double tor[], double delta[], double alpha[], Integer iq1,
                       Integer *ifail1);
  extern void g13ady_f(double cov[], double tor[], double err[], double wa[],
                       Integer iq1, double epsiln, Integer maxitn, Integer *ifail1);
  extern void g13adz_f(const double r[], Integer nl, const Integer mr[], double yv,
                       double par[], Integer npar, double wa[], Integer nwa,
                       double *rv, Integer isf[]);
  //Cheney add pointer to function 2006-6-5
  /*extern void g13aef_f(const Integer mr[], double par[], Integer npar, double *c,
                       Integer kfc, const double x[], Integer nx, Integer icount[],
                       double ex[], double exr[], double al[], Integer iex,
                       double *s, double g[], Integer igh, double sd[],
                       double h[], Integer ih, double st[], Integer ist,
                       Integer *nst, 
                       void (*piv)(const Integer [], const double [], Integer , double ,
                                   Integer , const Integer [], double , const double [],
                                   const double [], Integer , Integer , Integer ,
                                   const double []),
                       Integer kpiv, Integer nit, Integer *itc, double zsp[],
                       Integer kzsp, Integer isf[], double wa[], Integer iwa,
                       double hc[], Integer *ifail);*/
   extern void g13aef_f(const Integer mr[], double par[], Integer npar, double *c,
                       Integer kfc, const double x[], Integer nx, Integer icount[],
                       double ex[], double exr[], double al[], Integer iex,
                       double *s, double g[], Integer igh, double sd[],
                       double h[], Integer ih, double st[], Integer ist,
                       Integer *nst, 
                       NAG_G13AEF_F_FUN piv,
                       Integer kpiv, Integer nit, Integer *itc, double zsp[],
                       Integer kzsp, Integer isf[], double wa[], Integer iwa,
                       double hc[], Integer *ifail);
  extern void g13aet_f(const double aex[], const double aal[], const double aexr[], Integer na,
                       Integer np, Integer nd, Integer nq, Integer nps,
                       Integer nds, Integer nqs, Integer ns, double st[],
                       Integer nst);
  extern void g13aeu(Integer id, double *ex, double *alpha, double *a, Integer na,
                     double *w, double *beta, double *b, double *phi,
                     double *theta, double *sphi, double *stheta, Integer np,
                     Integer nq, Integer nps, Integer nqs, Integer ns, Integer npd);
  extern void g13aeu_f(Integer id, const double ex[], double alpha[], double a[],
                       Integer na, const double w[], double beta[], double b[],
                       Integer nb, const double phi[], const double theta[], const double sphi[],
                       const double stheta[], Integer nrmp, Integer np, Integer nq,
                       Integer nps, Integer nqs, Integer ns, Integer npd);
  extern void g13aeu_f(Integer id, const double ex[], double alpha[], double a[],
                       Integer na, const double w[], double beta[], double b[],
                       Integer nb, const double phi[], const double theta[], const double sphi[],
                       const double stheta[], Integer nrmp, Integer np, Integer nq,
                       Integer nps, Integer nqs, Integer ns, Integer npd);
  extern void g13aev_f(Integer np, Integer nq, Integer nps, Integer nqs,
                       Integer ns, const double aq[], Integer naq, const double bq[],
                       Integer nbq, Integer ksch, double al[], Integer na,
                       Integer nb, double *s, double g[], double h[],
                       Integer iz, Integer ngh);
  extern void g13aew_f(const double ex[], double alpha[], Integer na, double beta[],
                       Integer nb, double aq[], Integer naq, double bq[],
                       Integer nbq, Integer ksch, const double phi[], const double theta[],
                       const double sphi[], const double stheta[], Integer nrmp, Integer np,
                       Integer nq, Integer nps, Integer nqs, Integer ns,
                       Integer npd, Integer nqd);
  extern void g13aex_f(double zb[], Integer nzb, double eps, double *pg,
                       Integer *kc);
  extern void g13aex_f(double zb[], Integer nzb, double eps, double *pg,
                       Integer *kc);
  extern void g13aex(double *zb, Integer nzb, double eps, double *pg, Integer *kc);
  extern void g13aey_f(const Integer mpqs[], const double pa[], Integer ipa, Integer kwph,
                       Integer npar, double wb[], double ef, Integer mc[],
                       Integer *ierr);
  extern void g13aey(Integer *mpqs, double *pa, Integer kwph,
                     Integer npar, double *wb, double ef, Integer *mc,
                     Integer *ierr);
  extern void g13aey_f(const Integer mpqs[], const double pa[], Integer ipa, Integer kwph,
                       Integer npar, double wb[], double ef, Integer mc[],
                       Integer *ierr);
  extern void g13aez_f(const double par[], Integer npar, const Integer mpqs[], double wa[],
                       Integer iwa, Integer kwph);
  extern void g13aez_f(const double par[], Integer npar, const Integer mpqs[], double wa[],
                       Integer iwa, Integer kwph);
  extern void g13aez(double *par, Integer npar, Integer *mpqs, double *wa,
                     Integer kwph);
  extern void g13aff_f(const Integer mr[], double par[], Integer npar, double *c,
                       Integer kfc, const double x[], Integer nx, double *s,
                       Integer *ndf, double sd[], Integer nppc, double cm[],
                       Integer icm, double st[], Integer *nst, Integer kpiv,
                       Integer nit, Integer *itc, Integer isf[], double res[],
                       Integer ires, Integer *nres, Integer *ifail);
  extern void g13afz_f(const Integer mr[], const double par[], Integer npar, double c,
                       Integer kfc, const Integer icount[], double s, const double g[],
                       const double h[], Integer ih, Integer igh, Integer itc,
                       const double zsp[]);
  extern void g13ahx_f(double aex[], Integer nst, Integer nd, Integer nds,
                       Integer ns, Integer kdr, double *uv, double *dv);
  extern void g13ahx(double *aex, Integer nst, Integer nd, Integer nds,
                     Integer ns, Integer kdr, double *uv, double *dv);
  extern void g13ahy_f(const double st[], Integer nst, Integer np, Integer nd,
                       Integer nq, Integer nps, Integer nds, Integer nqs,
                       Integer ns, double aex[], double aal[], double aexr[]);
  extern void g13ahy(double *st, Integer nst, Integer np, Integer nd,
                     Integer nq, Integer nps, Integer nds, Integer nqs,
                     Integer ns, double *aex, double *aal, double *aexr);
  extern void g13ajy_f(const Integer mr[], Integer *np, Integer *nd, Integer *nq,
                       Integer *nps, Integer *nds, Integer *nqs, Integer *ns,
                       Integer *npd, Integer *ndd, Integer *nqd, Integer mpqs[],
                       Integer *npar);
  extern void g13ajy(Integer *mr, Integer *np, Integer *nd, Integer *nq,
                     Integer *nps, Integer *nds, Integer *nqs, Integer *ns,
                     Integer *npd, Integer *ndd, Integer *nqd, Integer *mpqs,
                     Integer *npar);
  extern NAG_DLL_EXPIMP void NAG_CALL g13asc(Nag_ArimaOrder *arimav, Integer n, const double v[],  Integer m,
					     const double par[], Integer npar, double c[],
					     double acfvar[], Integer im, double * sum2, Integer * idf,
					     double * siglev, NagError *fail);
  extern void g13asf_f(Integer n, const double v[], const Integer mr[], Integer m,
                       const double par[], Integer npar, Integer ishow, double c[],
                       double acfvar[], Integer im, double *sum2, Integer *idf,
                       double *siglev, Integer intgr[], Integer lmax, double work[],
                       Integer lwork, Integer *ifail);
  extern void g13asx_f(const double par[], Integer p, Integer q, Integer ps,
                       Integer qs, double fjac[], double var[], double acfvar[],
                       Integer npar, Integer m, Integer im, Integer isea,
                       double w[], Integer n, Integer lmax, Integer *ifaila);
  extern void g13asy_f(const double x[], Integer p, double fjac[], Integer s,
                       Integer ib, double phi[], Integer m, Integer npar,
                       double psi[], Integer maxp);

  extern NAG_DLL_EXPIMP void NAG_CALL g13auc(Integer n, const double z[],
                                             Integer m, const Nag_RangeStat rs,
                                             double y[], double mean[],
                                             NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13bac(const double y[], Integer ny, Nag_ArimaOrder *arimaf,
                                             Nag_ArimaOrder *arimav, const double par[], Integer npar,
                                             double cy, double b[], Integer nb, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g13bbc(const double y[], Integer ny, Nag_TransfOrder *transfv, Nag_ArimaOrder *arimas, const double par[], Integer npar, double cy, double b[], Integer nb, NagError *fail);

  extern  NAG_DLL_EXPIMP void NAG_CALL g13bcc(const double x[], const double y[], Integer nxy, Integer nl, double *s, double *r0, double r[], double *stat, NagError *fail); 

  extern  NAG_DLL_EXPIMP void NAG_CALL g13bdc(double r0, const double r[], Integer nl, Nag_TransfOrder *transfv, double s, double wds[], Integer isf[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g13bec(Nag_ArimaOrder *arimav, Integer nseries, Nag_TransfOrder *transfv,
                                             double para[], Integer npara, Integer nxxy, double xxy[],
                                             Integer tdxxy, double sd[], double *rss, double *objf,
                                             double *df, Nag_G13_Opt *options, NagError *fail);
  extern void g13bef_f(const Integer mr[], Integer nser, Integer mt[], double para[],
                       Integer npara, Integer kfc, Integer nxxy, double xxy[],
                       Integer ixxy, Integer kef, Integer nit, Integer kzsp,
                       double zsp[], Integer *itc, double sd[], double cm[],
                       Integer icm, double *s, double *d, Integer *ndf,
                       Integer kzef, double res[], double sttf[], Integer isttf,
                       Integer *nsttf, double wa[], Integer iwa, Integer mwa[],
                       Integer imwa, Integer kpriv, Integer *ifail);
  extern void g13bej_f(double xxy[], Integer ixxy, Integer n, Integer nxsp,
                       const double pxs[], Integer ipxs, const double wds[], Integer iwds,
                       Integer nfr, Integer mt[], double w[], Integer idw,
                       double sttf[], Integer isttf, Integer *nsttf, const Integer mr[],
                       double c, Integer kzef, const double bf[], Integer nbfq,
                       Integer nbf, Integer kss, Integer *ierr);
  extern void g13bej(double *xxy, Integer tdxxy, Nag_G13_Opt *opt, Integer n,
                     Integer nxsp, double *pxs, Integer ipxs,
                     double *wds, Integer iwds, Integer nfr, Integer *mt,
                     Integer tdmt, double *w, double *sttf, Integer isttf,
                     Integer *nsttf, Integer *mr, double c, Integer kzef,
                     double *bf, Integer nbf, Integer kss, Integer *ierr);
  extern void g13bek_f(const double a[], Integer ia, const double b[], Integer ib,
                       double apb[], Integer iapb, Integer na, Integer nb,
                       Integer *napb);
  extern void g13bek(double *a, double *b, double *apb, Integer na, Integer nb,
                     Integer *napb);
  extern void g13bel_f(const double x[], Integer n, const double px[], Integer idpx,
                       const double wd[], Integer nwd, Integer nnb, Integer nnp,
                       Integer nnq, Integer nnr, Integer npx, Integer *nex,
                       double ex[], double ez[], Integer idex);
  extern void g13bel(double *x, Integer n, double *px, double *wd, Integer nnb,
                     Integer nnp, Integer nnq, Integer nnr, Integer npx, Integer *nex,
                     double *ex, double *ez);
  extern void g13bem_f(Integer n4, const Integer msn[], const Integer mis[], const Integer mrn[],
                       Integer npe, Integer mord[], Integer mtyp[], Integer mser[],
                       Integer nxs);
  extern void g13bem(Integer n4, Integer *mis, Integer *mrn, Integer *mord,
                     Integer *mtyp, Integer *mser, Integer nxs);
  extern void g13ben_f(Integer mqab[], Integer mqsg[], Integer ja, Integer jb,
                       Integer nxsp, Integer krn, Integer msn[], Integer mspa[],
                       Integer mspb[], Integer imp, Integer *k, Integer kspa,
                       Integer kspb, Integer mis[], Integer mrn[]);
  extern void g13ben(Integer *mqab, Integer *mqsg, Integer ja, Integer jb,
                     Integer nxsp, Integer krn, Integer *msn, Integer *mspa,
                     Integer *mspb, Integer *k, Integer kspa, Integer kspb,
                     Integer *mis, Integer *mrn);
  extern void g13bep_f(const Integer mpab[], const Integer mpsg[], Integer krn, Integer msn[],
                       Integer mspa[], Integer mspb[], Integer imp, Integer *k,
                       Integer kspa, Integer kspb, Integer kspc, Integer mis[],
                       Integer mrn[]);
  extern void g13bep(Integer *mpab, Integer *mpsg, Integer krn, Integer *msn,
                     Integer *mspa, Integer *mspb, Integer *k, Integer kspa,
                     Integer kspb, Integer kspc, Integer *mis, Integer *mrn);
  extern void g13beq_f(double f[], double alpha[], double r[], Integer npd,
                       double *v);
  extern void g13beq(double *f, double *alpha, double *r, Integer npd, double *v);
  extern void g13ber_f(const double beta[], Integer nbeta, const Integer mop[], const Integer msn[],
                       Integer nms, Integer mqab[], Integer mqsg[], Integer nxsp,
                       double eps, double wd[], Integer idwd, Integer *ksfs);
  extern void g13ber(double *beta, Integer *mop, Integer *msn, Integer *mqab,
                     Integer *mqsg, Integer nxsp, double eps, double *wd,
                     Integer *ksfs);
  extern void g13bes_f(const Integer mpab[], Integer nms, Integer nmsq, Integer numw,
                       const Integer msn[], const Integer mspa[], const Integer mspb[], const double par[],
                       Integer npar, Integer kef, Integer nas, Integer nbs,
                       Integer nbvd, double h[], Integer ih, double wq[],
                       double wz[], const double a[], Integer ida, const double b[],
                       Integer idb, double gca[], double *delta, Integer np,
                       Integer nq, Integer nps, Integer ns, Integer nqd,
                       Integer npd, Integer npdq, double f[], double alpha[],
                       double r[], double s, Integer ndfva, Integer kfl,
                       double g[], Integer ngh, double phi[], double sphi[]);
  extern void g13bes(Integer *mpab, Integer nms, Integer nmsq, Integer numw,
                     Integer *msn, Integer *mspa, Integer *mspb, double *par,
                     Integer npar, Integer kef, Integer nas, Integer nbs,
                     Integer nbvd, double *h, Integer tdh, double *wq, Integer tdwq,
                     double *wz, double *a, double *b, double *gca, double *delta,
                     Integer np, Integer nq, Integer nps, Integer ns, Integer npd,
                     double *f, double *alpha, double *r, double s, Integer ndfva,
                     Integer kfl, double *g, Integer ngh, double *phi, double *sphi);
  extern void g13bet_f(const double a[], Integer ida, Integer n, double *d);
  extern void g13bet(double *a, Integer tda, Integer n, double *d);
  extern void g13beu_f(Integer lac, Integer lbc, const Integer msn[], const Integer maspa[],
                       const Integer maspb[], Integer nmsu, double a[], Integer ida,
                       double b[], Integer idb, Integer nbvd, double *s,
                       double g[], Integer igh, double h[], Integer ih,
                       const Integer mpab[]);
  extern void g13beu(Integer lac, Integer lbc, Integer *msn, Integer *maspa,
                     Integer *maspb, Integer nmsu, double *a, double *b,
                     Integer nbvd, double *s, double *g, double *h,
                     Integer tdh, Integer *mpab);
  extern void g13bev_f(const double xxy[], Integer ixxy, Integer n, const Integer mr[],
                       const double para[], Integer npara, double c, Integer kfc,
                       Integer nxsp, const double pxs[], Integer ipxs, const double bf[],
                       Integer nbfq, const double wds[], Integer iwds, Integer nbv,
                       Integer kef, Integer mt[], const Integer mpab[], Integer mqab[],
                       double a[], Integer ida, double b[], Integer idb,
                       double w[], Integer idw, Integer kab, Integer nbf,
                       Integer lbc);
  extern void g13bev(double *xxy, Integer tdxxy, Integer n, Integer *mr,
                     double *para, double c, Integer kfc, Integer nxsp,
                     double *pxs, Integer ipxs, double *bf, double *wds,
                     Integer iwds, Integer nbv, Integer kef, Integer *mt,
                     Integer tdmt, Integer *mpab, Integer *mqab, double *a,
                     Integer ida, double *b, Integer idb, double *w,
                     Integer idw, Integer kab, Integer nbf, Integer lbc);
  extern void g13bew(double *beta, Integer nbeta, double *para, Integer npar,
                     double *bf, double *pxs, Integer ipxs,
                     double *wds, Integer iwds, double *c, Integer kef, Integer *mop,
                     Integer *mis, Integer *mrn, Integer kfbs, Integer klbs);
  extern void g13bew_f(const double beta[], Integer nbeta, double para[], Integer npara,
                       Integer npar, double bf[], Integer nbfq, Integer nxsp,
                       double pxs[], Integer npxq, double wds[], Integer nwdq,
                       double *c, Integer kef, const Integer mop[], const Integer mis[],
                       const Integer mrn[], Integer nms, Integer kfbs, Integer klbs);
  extern void g13bex(Integer *mt, Integer tdmt, Integer kcol, Integer nxsp,
                     Integer *nnb, Integer *nnp, Integer *nnq, Integer *nnr,
                     Integer *nwd, Integer *ngw, Integer *npx);
  extern void g13bex_f(Integer mt[], Integer kcol, Integer nxsp, Integer *nnb,
                       Integer *nnp, Integer *nnq, Integer *nnr, Integer *nwd,
                       Integer *ngw, Integer *npx);
  extern void g13bey(Integer *mpqs, Integer nxsp, Integer nbf, Integer kfc,
                     Integer kef, Integer *mt, Integer tdmt, Integer *mpab,
                     Integer *mqab, Integer tdmqab, Integer *kcp, Integer *mpsg,
                     Integer *mqsg, Integer tdmqsg, Integer np, Integer nps,
                     Integer ns, Integer *msn, Integer *mspa, Integer *mspb,
                     Integer *mop, Integer *mis, Integer *mrn);
  extern void g13bey_f(const Integer mpqs[], Integer nxsp, Integer nbf, Integer kfc,
                       Integer kef, Integer mt[], Integer mpab[], Integer mqab[],
                       Integer *kcp, Integer mpsg[], Integer mqsg[], Integer np,
                       Integer nps, Integer ns, Integer msn[], Integer mspa[],
                       Integer mspb[], Integer imp, Integer mop[], Integer mis[],
                       Integer mrn[]);
  extern void g13bez(Integer nxs, Integer *mt, Integer tdmt, Integer np,
                     Integer nq, Integer nps, Integer nqs, Integer ns,
                     Integer ndd, Integer nqd, Integer kef, Integer *nbss,
                     Integer *nbv, Integer *nbf, Integer nxsp);
  extern void g13bez_f(Integer nxs, Integer mt[], Integer np, Integer nq,
                       Integer nps, Integer nqs, Integer ns, Integer ndd,
                       Integer nqd, Integer kef, Integer *nbss, Integer *nbv,
                       Integer *nbf, Integer nxsp);
  extern void g13bfr(double *ex, double *alpha, double *a, double *pa,
                     Integer na, double *w, double *beta, double *b, double *wa,
                     Integer nrmp, Integer kdq, Integer np, Integer nq,
                     Integer nps, Integer nqs, Integer ns, Integer npd,
                     Integer *mpqs, Integer nas, Integer nbs);
  extern void g13bfr_f(const double ex[], double alpha[], double a[], const double pa[],
                       Integer na, Integer ida, const double w[], double beta[],
                       double b[], Integer idw, Integer idb, const double wa[],
                       Integer idwa, Integer nrmp, Integer kdq, Integer np,
                       Integer nq, Integer nps, Integer nqs, Integer ns,
                       Integer npd, const Integer mpqs[], Integer nas, Integer nbs);
  extern void g13bfs(double *f, double *r, double *alpha, Integer npd,
                     double *phi, Integer np, double *sphi, Integer nps,
                     double *dva, Integer iddv, Integer ns,  double v);
  extern void g13bfs_f(const double f[], const double r[], double alpha[], Integer npd,
                       const double phi[], Integer np, const double sphi[], Integer nps,
                       double dva[], Integer iddv, Integer ns, double v);
  extern void g13bft(Integer *mpab, Integer nms, Integer num, Integer numw,
                     Integer *msn, Integer *mspa, Integer *mspb, Integer npar,
                     Integer nas, Integer nbs, Integer nbvd,  double *h,
                     Integer tdh, double *wq, Integer tdwq, double *wz,
                     double *a, double *b, double *gc, NagError *fail);
  extern void g13bft_f(const Integer mpab[], Integer nms, Integer num, Integer numw,
                       const Integer msn[], const Integer mspa[], const Integer mspb[], Integer npar,
                       Integer kef, Integer nas, Integer nbs, Integer nbvd,
                       double h[], Integer ih, double wq[], Integer iwq,
                       double wz[], const double a[], Integer ida, const double b[],
                       Integer idb, double gc[], Integer *ifail);
  extern void g13bfu(double *f, double *r, double *alpha, Integer npd, Integer ks,
                     double v);
  extern void g13bfu_f(const double f[], const double r[], double alpha[], Integer npd,
                       Integer ks, double v);
  extern void g13bfv_f(const double phi[], Integer np, const double sphi[], Integer nps,
                       double f[], double alpha[], Integer npd, Integer ns,
                       double *delta);
  extern void g13bfv(double *phi, Integer np, double *sphi, Integer nps,
                     double *f, double *alpha, Integer npd, Integer ns,
                     double *delta);
  extern void g13bfw_f(const double h[], Integer idh, Integer i, Integer j,
                       Integer ksgn, Integer num, double *f, Integer *kfl,
                       const Integer msn[], Integer nms, Integer *ix, Integer *jx);
  extern void g13bfw(double *h, Integer tdh, Integer i, Integer j,
                     Integer ksgn, double *f, Integer *kfl,
                     Integer *msn, Integer *ix, Integer *jx);
  extern void g13bfx_f(Integer itc, double s, double d, const double para[],
                       Integer npara, Integer npe, const Integer mtyp[], const Integer mser[],
                       Integer ktf, Integer ktfv);
  extern void g13bfx(Integer itc, double s, double d, double *para,
                     Integer npara, double *sd, double df,
                     Integer npe, Integer *mtyp, Integer *mser, Nag_Comm *comm,
                     Nag_FileSt *stream, Nag_G13_Opt *opt);
  extern void g13bfy_f(const Integer mr[], Integer npara, double para[], Integer npe,
                       Integer nxy, double xxy[], Integer ixxy, Integer nxsp,
                       Integer mt[], Integer kef, Integer nit, double zsp[],
                       Integer *itc, double sd[], double cm[], Integer icm,
                       double *s, double *d, Integer kzef, double res[],
                       Integer mwa[], Integer imwa, double beta[], double betac[],
                       Integer ngh, double g[], double gc[], Integer ih,
                       double h[], double hc[], double delt[], Integer iwds,
                       double wds[], Integer nbfq, double bf[], Integer ipxs,
                       double pxs[], double wae[], Integer iwae, double *c,
                       Integer kpriv, double sttf[], Integer isttf, Integer *nsttf,
                       Integer *ierr);
  extern void g13bfy(Integer *mr, Integer npara, double *para, Integer npe,
                     Integer nxy, double *xxy, Integer tdxxy,
                     Integer nxsp, Integer *mt, Integer tdmt, Integer kef,
                     Integer nit, double *zsp, Integer *itc, double *sd,
                     double df, double *cm,
                     Integer tdcm, double *s, double *d, Integer kzef, double *res,
                     Integer *mwa, double *beta, double *betac,
                     Integer ngh, double *g, double *gc, Integer ih, double *h,
                     Integer tdh, double *hc, Integer tdhc, double *delt,
                     Integer iwds, double *wds, double *bf,
                     Integer ipxs, double *pxs,
                     double *c, double *sttf,
                     Integer isttf, Integer *nsttf, Integer *ierr,
                     Nag_Comm *comm, Nag_FileSt *stream,
                     Nag_G13_Opt *opt);
  extern void g13bhf_f(double sttf[], Integer nsttf, Integer mr[], Integer nser,
                       Integer mt[], const double para[], Integer npara, Integer nfv,
                       double xxyn[], Integer ixxyn, Integer mrx[], const double parx[],
                       Integer iparx, const double rmsxy[], Integer kzef, double fva[],
                       double fsd[], double wa[], Integer iwa, Integer *ifail);
  extern void g13bhx_f(double sttf[], Integer nsttf, Integer kpst, Integer nwd,
                       double xc[], Integer lxc, double zc[], Integer lzc,
                       const double para[], Integer npara, Integer kppa, const double xn[],
                       double zn[], Integer nnv, Integer kustf);
  extern void g13bhx(double *sttf, Integer kpst, Integer nwd, double *xc,
                     Integer lxc, double *zc, Integer lzc, double *para,
                     Integer kppa, double *xn, double *zn, Integer nnv,
                     Integer kustf);
  extern void g13bhy_f(const double st[], Integer nst, Integer np, Integer nd,
                       Integer nq, Integer nps, Integer nds, Integer nqs,
                       Integer ns, const double phi[], const double theta[], const double sphi[],
                       const double stheta[], Integer nparq, double *c, double rms,
                       Integer nfv, double fva[], double fsd[], Integer kfva,
                       double aex[], double aal[], double aexr[]);
  extern void g13bhy(double *st, Integer nst, Integer np, Integer nd, Integer nq,
                     Integer nps, Integer nds, Integer nqs, Integer ns,
                     double *phi, double *theta, double *sphi, double *stheta,
                     double *c, double rms, Integer nfv, double *fva,
                     double *fsd, Integer kfva, double *aex, double *aal,
                     double *aexr);
  extern void g13bhz_f(Integer mr[], const double para[], Integer npara, double sttf[],
                       Integer nsttf, Integer mt[], Integer nxsp, Integer mrx[],
                       const double parx[], Integer iparx, double xxyn[], Integer ixxyn,
                       const double rmsxy[], Integer nfv, Integer kzef, double fva[],
                       double fsd[], double psi[], double aex[], double aal[],
                       double zn[], Integer ips, double wa[], Integer iwa,
                       Integer npxy);
  extern void g13bhz(Integer *mr, double *para, Integer npara, double *sttf,
                     Integer *nsttf, Integer *mt, Integer tdmt, Integer nxsp,
                     Integer *mrx, Integer tdmrx, double *parx, Integer tdparx,
                     double *xxyn, Integer tdxxyn, Nag_G13_Opt *opt,
                     double *rmsxy, Integer nfv, Integer kzef, double *fva,
                     double *fsd, double *psi, double *aex, double *aal, double *zn,
                     Integer ips, double *wa, Integer iwa, Integer npxy);
  extern NAG_DLL_EXPIMP void NAG_CALL g13bjc(Nag_ArimaOrder *arimav, Integer nseries, Nag_TransfOrder *transfv,
                                             double para[], Integer npara, Integer nev, Integer nfv,
                                             double xxy[], Integer tdxxy, double rmsxy[],
                                             Integer mrx[], Integer tdmrx, double parx[], Integer ldparx,
                                             Integer tdparx, double fva[], double fsd[], Nag_G13_Opt *options,
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13bxc(Nag_G13_Opt *options);
  extern void g13bxz(Nag_ArimaOrder *arimav, Nag_TransfOrder *transfv, Integer nseries,
                     Integer mr[], Integer mt[]);
  extern NAG_DLL_EXPIMP void NAG_CALL g13byc(Integer nseries, Nag_TransfOrder *transfv, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13bzc(Nag_TransfOrder *transfv);

  extern NAG_DLL_EXPIMP void NAG_CALL g13cac(Integer nx, Integer mtx, double px, Integer iw, Integer mw, Integer ic, Integer nc, double c[], Integer kc, Integer l, Nag_LoggedSpectra lg_spect, Integer nxg, double xg[], Integer *ng, double stats[], NagError *fail); 

  //Cheney change pi to dpi 2006-6-5
  /*extern double g13caw(Integer iw,  double s3, double pi);
  extern void g13cax(double xg[],  Integer nx, Integer m,  double pi);*/
  extern double g13caw(Integer iw,  double s3, double dpi);
  extern void g13cax(double xg[],  Integer nx, Integer m,  double dpi);
  extern void g13cay(double xg[],  Integer nx, Integer mtx);
  extern void g13caz(Integer nx, Integer mtx,  double px,  Integer iw,
                     Integer mw, Integer ic, Integer nc,  double c[],
                     Integer kc, Integer l, Integer lg, Integer nxg,
                     double xg[],  Integer *ng,  double stats[],
                     Integer *ierror);
  extern NAG_DLL_EXPIMP void NAG_CALL g13cbc(Integer nx, NagMeanOrTrend mt_correction,  double px,  Integer mw,
                                             double pw,  Integer l, Integer kc, Nag_LoggedSpectra lg_spect,
                                             double x[], double **g,  Integer *ng,  double stats[],
                                             NagError *fail);
  //Cheney Change Complex to complex
  /*extern NAG_DLL_EXPIMP void NAG_CALL g13ccc(Integer nxy, NagMeanOrTrend mtxy_correction, 
  				double pxy, Integer iw, Integer mw, Integer ish, Integer ic, Integer nc, double cxy[], 
  				double cyx[], Integer kc, Integer l, const double xg[], const double yg[], Complex g[], 
  				Integer *ng, NagError *fail);*/
 extern NAG_DLL_EXPIMP void NAG_CALL g13ccc(Integer nxy, NagMeanOrTrend mtxy_correction, 
  				double pxy, Integer iw, Integer mw, Integer ish, Integer ic, Integer nc, double cxy[], 
  				double cyx[], Integer kc, Integer l, const double xg[], const double yg[], complex g[], 
  				Integer *ng, NagError *fail);

  extern void g13ccy(double x[],  Integer k, Integer m,  double *s1,
                     double *s2);
  extern void g13ccz(Integer nxy, Integer mtxy,  double pxy,  Integer iw,
                     Integer mw, Integer is, Integer ic, Integer nc,
                     double cxy[], double cyx[],  Integer kc, Integer l,
                     Integer nxyg,  double xg[], double yg[],  Integer *ng,
                     Integer *ierror);
  //Cheney Change Complex to complex
  /*extern NAG_DLL_EXPIMP void NAG_CALL g13cdc(Integer nxy, NagMeanOrTrend mt_correction, double pxy,  Integer mw,
                                             Integer is,  double pw,  Integer l, Integer kc,
                                             double x[], double y[],  Complex **g, Integer *ng, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13cec(double xg[], double yg[], Complex xyg[],  Integer ng,
                                             double stats[], double ca[], double calw[], double caup[],
                                             double *t, double sc[], double sclw[], double scup[],
                                             NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL g13cdc(Integer nxy, NagMeanOrTrend mt_correction, double pxy,  Integer mw,
                                             Integer is,  double pw,  Integer l, Integer kc,
                                             double x[], double y[],  complex **g, Integer *ng, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13cec(double xg[], double yg[], complex xyg[],  Integer ng,
                                             double stats[], double ca[], double calw[], double caup[],
                                             double *t, double sc[], double sclw[], double scup[],
                                             NagError *fail);
  extern void g13cez(double xg[], double yg[], double xyrg[],
                     double xyig[],  Integer ng,  double stats[],
                     double ca[], double calw[], double caup[],
                     double *t, double sc[], double sclw[],
                     double scup[],  Integer *ierror);
 //Cheney Change Complex to complex
  /*extern NAG_DLL_EXPIMP void NAG_CALL g13cfc(double xg[], double yg[], Complex xyg[], Integer ng,
                                             double stats[], double gn[], double gnlw[], double gnup[],
                                             double ph[], double phlw[], double phup[],
                                             NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL g13cfc(double xg[], double yg[], complex xyg[], Integer ng,
                                             double stats[], double gn[], double gnlw[], double gnup[],
                                             double ph[], double phlw[], double phup[],
                                             NagError *fail);
  extern void g13cfz(double xg[], double yg[], double xyrg[],
                     double xyig[],  Integer ng,  double stats[],
                     double gn[], double gnlw[], double gnup[],
                     double ph[], double phlw[], double phup[],
                     Integer *ierror);
  //Cheney Change Complex to complex
  /*extern NAG_DLL_EXPIMP void NAG_CALL g13cgc(double xg[], double yg[], Complex xyg[], Integer ng,
                                             double stats[],  Integer l, Integer n,  double er[],
                                             double *erlw, double *erup, double rf[], double *rfse,
                                             NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL g13cgc(double xg[], double yg[], complex xyg[], Integer ng,
                                             double stats[],  Integer l, Integer n,  double er[],
                                             double *erlw, double *erup, double rf[], double *rfse,
                                             NagError *fail);
  extern void g13cgz(double xg[], double yg[], double xyrg[],
                     double xyig[],  Integer ng,  double stats[],  Integer l,
                     Integer n,  double er[], double *erlw, double *erup,
                     double rf[], double *rfse,  Integer *ierror);

  extern NAG_DLL_EXPIMP void NAG_CALL g13dbc(const double c0[], const double c[], Integer ns, Integer nl, Integer nk, double p[], double *v0, double v[], double d[], double db[], double w[], double wb[], Integer *nvp, NagError *fail);


  extern NAG_DLL_EXPIMP void NAG_CALL g13dlc(Integer k, Integer n, const double z[], const Integer tr[], const Integer id[], const double delta[], double w[], Integer *nd, NagError *fail);

  //Cheney change matrix to mat 2006-6-5
  //extern NAG_DLL_EXPIMP void NAG_CALL g13dmc(Nag_CovOrCorr matrix, Integer k, Integer n, Integer m, const double w[], double wmean[], double r0[], double r[], NagError *fail); 
  extern NAG_DLL_EXPIMP void NAG_CALL g13dmc(Nag_CovOrCorr mat, Integer k, Integer n, Integer m, const double w[], double wmean[], double r0[], double r[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g13dnc(Integer k, Integer n, Integer m, const double r0[], const double r[], Integer *maxlag, double parlag[], double x[], double pvalue[], NagError *fail); 


  extern NAG_DLL_EXPIMP void NAG_CALL g13dpc(Integer k, Integer n, const double z[], Integer m, Integer *maxlag, double parlag[], double se[], double qq[], double x[], double pvalue[], double loglhd[], NagError *fail); 


  extern NAG_DLL_EXPIMP void NAG_CALL g13dxc(Integer k, Integer ip, const double par[], double rr[], double ri[], double rmod[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g13eac(Integer n, Integer m, Integer p, double s[], Integer tds,
                                             double a[], Integer tda, double b[], Integer tdb,
                                             double q[], Integer tdq, double c[], Integer tdc,
                                             double r[], Integer tdr, double k[], Integer tdk, 
                                             double h[], Integer tdh, double tol, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13ebc(Integer n, Integer m, Integer p, double s[], Integer tds,
                                             double a[], Integer tda, double b[], Integer tdb, double q[],
                                             Integer tdq, double c[], Integer tdc, double r[], Integer tdr,
                                             double k[], Integer tdk, double h[], Integer tdh,
                                             double tol, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13ecc(Integer n, Integer m, Integer p,
                                             Nag_ab_input inp_ab,double t[], Integer tdt,
                                             double ainv[], Integer tda, double b[], Integer tdb, 
                                             double rinv[], Integer tdr, double c[], Integer tdc,
                                             double qinv[], Integer tdq, double x[], double rinvy[], 
                                             double z[], double tol,
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13edc(Integer n, Integer m, Integer p, 
                                             double t[], Integer tdt, double ainv[], Integer tda,
                                             double ainvb[], Integer tdai, double rinv[], Integer tdr,
                                             double c[], Integer tdc, double qinv[], Integer tdq, double x[],
                                             double rinvy[], double z[], double tol,  NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13ewc(Integer n, Integer p,  Nag_ObserverForm reduceto, double a[],
                                             Integer tda, double c[], Integer tdc, double u[], Integer tdu,
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13exc(Integer n, Integer m, Nag_ControllerForm reduceto, double a[],
                                             Integer tda, double b[], Integer tdb, double u[], Integer tdu, 
                                             NagError *fail);
  extern void g13exy(MatrixType uplo, Integer n, double t[],
                     Integer tdt, double *rcond, Integer *ifail);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fac(const double  yt[], const double  x[], Integer ldx, Integer num,
                       Integer ip, Integer iq, Integer nreg, Integer mn,
                       Integer isym, double  theta[], double  se[], double  sc[],
                       double  covar[], Integer ldc, double  *hp, double  etm[],
                       double  htm[], double  *lgf, Nag_Garch_Stationary_Type stat_opt,
                       Nag_Garch_Est_Initial_Type est_opt, Integer maxit,
                       double  tol, NagError *ifail);
  extern void g13fay (Integer n, double x[], double *objf, double objgrd[], Nag_Comm *comm);
  extern void g13faz(Integer mode, Integer m, const double  x[], double  *objf,
                     double  grad[], Integer nstate, Integer iuser[], double  yt[]);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fbc(Integer num, Integer nt, Integer ip, Integer iq,
                       const double  theta[], double  gamma, double  cvar[], const double  ht[],
                       const double  et[], NagError *ifail);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fcc(const double yt[], const double x[], Integer ldx, Integer num,
                       Integer ip, Integer iq, Integer nreg, Integer mn,
                       double theta[], double se[], double sc[], double covar[],
                       Integer ldc, double *hp, double etm[], double htm[],
                       double *lgf, Nag_Garch_Stationary_Type stat_opt,
                       Nag_Garch_Est_Initial_Type est_opt, Integer maxit, double tol, NagError *ifail);
  extern void g13fcy (Integer n, double x[], double *objf, double objgrd[], Nag_Comm *comm);
  extern void g13fcz(Integer mode, Integer m, const double x[], double *objf,
                     double grad[], Integer nstate, Integer iuser[], double yt[]);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fdc(Integer num, Integer nt, Integer ip, Integer iq,
                       const double theta[], double gamma, double cvar[], const double ht[],
                       const double et[], NagError *ifail);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g13fec(const double yt[], const double x[], Integer ldx, Integer num,
		       Integer ip, Integer iq, Integer nreg, Integer mn,
		       double theta[], double se[], double sc[], double covar[],
		       Integer ldc, double * hp, double etm[], double htm[],
		       double * lgf, Nag_Garch_Stationary_Type stat_opt,
		       Nag_Garch_Est_Initial_Type est_opt, Integer maxit, double tol,
		       NagError *ifail);
  extern void g13fey (Integer n, double x[], double *objf, double objgrd[], Nag_Comm *comm);
  extern void g13fez(Integer mode, Integer m, const double x[], double *objf,
                     double grad[], Integer nstate, Integer iuser[], double yt[]);
  extern NAG_DLL_EXPIMP
  void NAG_CALL g13ffc(Integer num, Integer nt, Integer ip, Integer iq,
                       const double theta[], double gamma, double cvar[],
                       const double ht[], const double et[], NagError *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g13xzc(Nag_G13_Opt *options);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG13 */
